﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SharePoint.Client;

namespace IterateGroupsAndUsers
{
   class Program
   {
      static void Main(string[] args)
      {
         ClientContext ctx = new ClientContext("http://contoso.de");

         // Liste der Gruppen der Websitesammlung
         GroupCollection siteGroups = ctx.Web.SiteGroups;

         // Gruppen und Benutzer-Eigenschaften laden
         ctx.Load(siteGroups,
            group => group.Include(
               g => g.Title,
               g => g.Users.Include(
                  u => u.Title,
                  u => u.Email,
                  u => u.LoginName)));

         ctx.ExecuteQuery();

         // Sämtliche Gruppen iterieren
         foreach (Group g in siteGroups)
         {
            Console.WriteLine("{0}", g.Title);

            // Benutzer einer Gruppe auslesen
            foreach (User u in g.Users)
            {
               Console.WriteLine("> {0} ({1}, {2})",
                  u.Title, u.LoginName, u.Email);
            }
            Console.WriteLine();
         }

      }
   }
}
